%------------------------------------------------------------------------------
% File     : DAT169^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Data Structures
% Problem  : Huffman 1448
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [Bla08] Blanchette (2008), The Textbook Proof of Huffman's Alg
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : huffman__1448.p [Bla16]

% Status   : Theorem
% Rating   : 1.00 v7.2.0, 0.75 v7.1.0
% Syntax   : Number of formulae    :  396 ( 143 unt;  76 typ;   0 def)
%            Number of atoms       :  780 ( 351 equ;   0 cnn)
%            Maximal formula atoms :   12 (   2 avg)
%            Number of connectives : 4228 (  88   ~;  15   |;  42   &;3771   @)
%                                         (   0 <=>; 312  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   25 (   6 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :  142 ( 142   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   76 (  73 usr;  12 con; 0-6 aty)
%            Number of variables   :  935 (  15   ^; 850   !;   8   ?; 935   :)
%                                         (  62  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:42:05.394
%------------------------------------------------------------------------------
%----Could-be-implicit typings (6)
thf(ty_t_Huffman__Mirabelle__gjololrwrm_Otree,type,
    huffma16452318e_tree: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_Int_Oint,type,
    int: $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

thf(ty_tf_a,type,
    a: $tType ).

%----Explicit typings (70)
thf(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Osemiring,type,
    semiring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Num_Oneg__numeral,type,
    neg_numeral: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Ocomm__semiring,type,
    comm_semiring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Osemigroup__add,type,
    semigroup_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Osemigroup__mult,type,
    semigroup_mult: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Olinordered__ring,type,
    linordered_ring: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Olinordered__ring__strict,type,
    linord581940658strict: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocancel__comm__monoid__add,type,
    cancel1352612707id_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__comm__monoid__add,type,
    ordere216010020id_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__ab__semigroup__add,type,
    ordere779506340up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Osemiring__no__zero__divisors,type,
    semiri1193490041visors: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Olinordered__semiring__strict,type,
    linord20386208strict: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ocanonically__ordered__monoid__add,type,
    canoni770627133id_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ostrict__ordered__comm__monoid__add,type,
    strict797366125id_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__cancel__ab__semigroup__add,type,
    ordere223160158up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Ostrict__ordered__ab__semigroup__add,type,
    strict2144017051up_add: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Osemiring__no__zero__divisors__cancel,type,
    semiri1923998003cancel: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Groups_Oordered__ab__semigroup__monoid__add__imp__le,type,
    ordere516151231imp_le: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Oalphabet,type,
    huffma505251170phabet: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > ( set @ A ) ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_OcachedWeight,type,
    huffma787811817Weight: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > nat ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Oconsistent,type,
    huffma1050891809istent: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > $o ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Ocost,type,
    huffma636208924e_cost: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > nat ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Odepth,type,
    huffma223349076_depth: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > A > nat ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Ofreq,type,
    huffma854352999e_freq: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > A > nat ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Oheight,type,
    huffma1554076246height: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > nat ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Osibling,type,
    huffma943100115ibling: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > A > A ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_OswapLeaves,type,
    huffma2094459102Leaves: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > nat > A > nat > A > ( huffma16452318e_tree @ A ) ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Otree_OInnerNode,type,
    huffma1759677307erNode: 
      !>[A: $tType] : ( nat > ( huffma16452318e_tree @ A ) > ( huffma16452318e_tree @ A ) > ( huffma16452318e_tree @ A ) ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Otree_OLeaf,type,
    huffma1554276827e_Leaf: 
      !>[A: $tType] : ( nat > A > ( huffma16452318e_tree @ A ) ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Otree_Ocase__tree,type,
    huffma570615019e_tree: 
      !>[A: $tType,B: $tType] : ( ( nat > A > B ) > ( nat > ( huffma16452318e_tree @ A ) > ( huffma16452318e_tree @ A ) > B ) > ( huffma16452318e_tree @ A ) > B ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Otree_Opred__tree,type,
    huffma1727904060d_tree: 
      !>[A: $tType] : ( ( A > $o ) > ( huffma16452318e_tree @ A ) > $o ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Otree_Orec__tree,type,
    huffma577982705c_tree: 
      !>[A: $tType,C: $tType] : ( ( nat > A > C ) > ( nat > ( huffma16452318e_tree @ A ) > ( huffma16452318e_tree @ A ) > C > C > C ) > ( huffma16452318e_tree @ A ) > C ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_OuniteTrees,type,
    huffma453905539eTrees: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > ( huffma16452318e_tree @ A ) > ( huffma16452318e_tree @ A ) ) ).

thf(sy_c_Huffman__Mirabelle__gjololrwrm_Oweight,type,
    huffma691733767weight: 
      !>[A: $tType] : ( ( huffma16452318e_tree @ A ) > nat ) ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

thf(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Pure_Otype,type,
    type: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_a,type,
    a2: a ).

thf(sy_v_b,type,
    b: a ).

thf(sy_v_t_092_060_094sub_0621____,type,
    t_1: huffma16452318e_tree @ a ).

thf(sy_v_t_092_060_094sub_0622____,type,
    t_2: huffma16452318e_tree @ a ).

thf(sy_v_w_092_060_094sub_062a,type,
    w_a: nat ).

thf(sy_v_w_092_060_094sub_062s,type,
    w_s: nat ).

thf(sy_v_w____,type,
    w: nat ).

thf(sy_v_x21______,type,
    x21: nat ).

thf(sy_v_x22______,type,
    x22: huffma16452318e_tree @ a ).

thf(sy_v_x23______,type,
    x23: huffma16452318e_tree @ a ).

%----Relevant facts (254)
thf(fact_0_h_092_060_094sub_0621,axiom,
    ( ( huffma1554076246height @ a @ t_1 )
    = ( zero_zero @ nat ) ) ).

% h\<^sub>1
thf(fact_1_InnerNode,axiom,
    ( t_1
    = ( huffma1759677307erNode @ a @ x21 @ x22 @ x23 ) ) ).

% InnerNode
thf(fact_2_hyps_I5_J,axiom,
    a2 != b ).

% hyps(5)
thf(fact_3_tree_Oinject_I2_J,axiom,
    ! [A: $tType,X21: nat,X22: huffma16452318e_tree @ A,X23: huffma16452318e_tree @ A,Y21: nat,Y22: huffma16452318e_tree @ A,Y23: huffma16452318e_tree @ A] :
      ( ( ( huffma1759677307erNode @ A @ X21 @ X22 @ X23 )
        = ( huffma1759677307erNode @ A @ Y21 @ Y22 @ Y23 ) )
      = ( ( X21 = Y21 )
        & ( X22 = Y22 )
        & ( X23 = Y23 ) ) ) ).

% tree.inject(2)
thf(fact_4_hyps_I4_J,axiom,
    ( ( huffma943100115ibling @ a @ ( huffma1759677307erNode @ a @ w @ t_1 @ t_2 ) @ b )
   != b ) ).

% hyps(4)
thf(fact_5_hyps_I3_J,axiom,
    huffma1050891809istent @ a @ ( huffma1759677307erNode @ a @ w @ t_1 @ t_2 ) ).

% hyps(3)
thf(fact_6_hyps_I1_J,axiom,
    ( ( huffma1050891809istent @ a @ t_1 )
   => ( ( ( huffma943100115ibling @ a @ t_1 @ b )
       != b )
     => ( ( a2 != b )
       => ( ( huffma943100115ibling @ a @ ( huffma2094459102Leaves @ a @ t_1 @ w_a @ a2 @ w_s @ ( huffma943100115ibling @ a @ t_1 @ b ) ) @ a2 )
          = b ) ) ) ) ).

% hyps(1)
thf(fact_7_hyps_I2_J,axiom,
    ( ( huffma1050891809istent @ a @ t_2 )
   => ( ( ( huffma943100115ibling @ a @ t_2 @ b )
       != b )
     => ( ( a2 != b )
       => ( ( huffma943100115ibling @ a @ ( huffma2094459102Leaves @ a @ t_2 @ w_a @ a2 @ w_s @ ( huffma943100115ibling @ a @ t_2 @ b ) ) @ a2 )
          = b ) ) ) ) ).

% hyps(2)
thf(fact_8_swapLeaves_Osimps_I2_J,axiom,
    ! [A: $tType,W: nat,T_1: huffma16452318e_tree @ A,T_2: huffma16452318e_tree @ A,W_a: nat,A2: A,W_b: nat,B2: A] :
      ( ( huffma2094459102Leaves @ A @ ( huffma1759677307erNode @ A @ W @ T_1 @ T_2 ) @ W_a @ A2 @ W_b @ B2 )
      = ( huffma1759677307erNode @ A @ W @ ( huffma2094459102Leaves @ A @ T_1 @ W_a @ A2 @ W_b @ B2 ) @ ( huffma2094459102Leaves @ A @ T_2 @ W_a @ A2 @ W_b @ B2 ) ) ) ).

% swapLeaves.simps(2)
thf(fact_9_height__swapLeaves,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,W_a: nat,A2: A,W_b: nat,B2: A] :
      ( ( huffma1554076246height @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B2 ) )
      = ( huffma1554076246height @ A @ T ) ) ).

% height_swapLeaves
thf(fact_10_height__0__imp__sibling__id,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( ( huffma1554076246height @ A @ T )
        = ( zero_zero @ nat ) )
     => ( ( huffma943100115ibling @ A @ T @ A2 )
        = A2 ) ) ).

% height_0_imp_sibling_id
thf(fact_11_tree_Osimps_I6_J,axiom,
    ! [B: $tType,A: $tType,F1: nat > A > B,F2: nat > ( huffma16452318e_tree @ A ) > ( huffma16452318e_tree @ A ) > B,X21: nat,X22: huffma16452318e_tree @ A,X23: huffma16452318e_tree @ A] :
      ( ( huffma570615019e_tree @ A @ B @ F1 @ F2 @ ( huffma1759677307erNode @ A @ X21 @ X22 @ X23 ) )
      = ( F2 @ X21 @ X22 @ X23 ) ) ).

% tree.simps(6)
thf(fact_12_cachedWeight_Osimps_I2_J,axiom,
    ! [A: $tType,W: nat,T_1: huffma16452318e_tree @ A,T_2: huffma16452318e_tree @ A] :
      ( ( huffma787811817Weight @ A @ ( huffma1759677307erNode @ A @ W @ T_1 @ T_2 ) )
      = W ) ).

% cachedWeight.simps(2)
thf(fact_13_sibling_Osimps_I2_J,axiom,
    ! [A: $tType,A2: A,B2: A,W: nat,W_b: nat,W_c: nat,C2: A] :
      ( ( ( A2 = B2 )
       => ( ( huffma943100115ibling @ A @ ( huffma1759677307erNode @ A @ W @ ( huffma1554276827e_Leaf @ A @ W_b @ B2 ) @ ( huffma1554276827e_Leaf @ A @ W_c @ C2 ) ) @ A2 )
          = C2 ) )
      & ( ( A2 != B2 )
       => ( ( ( A2 = C2 )
           => ( ( huffma943100115ibling @ A @ ( huffma1759677307erNode @ A @ W @ ( huffma1554276827e_Leaf @ A @ W_b @ B2 ) @ ( huffma1554276827e_Leaf @ A @ W_c @ C2 ) ) @ A2 )
              = B2 ) )
          & ( ( A2 != C2 )
           => ( ( huffma943100115ibling @ A @ ( huffma1759677307erNode @ A @ W @ ( huffma1554276827e_Leaf @ A @ W_b @ B2 ) @ ( huffma1554276827e_Leaf @ A @ W_c @ C2 ) ) @ A2 )
              = A2 ) ) ) ) ) ).

% sibling.simps(2)
thf(fact_14_tree_Osimps_I8_J,axiom,
    ! [C: $tType,A: $tType,F1: nat > A > C,F2: nat > ( huffma16452318e_tree @ A ) > ( huffma16452318e_tree @ A ) > C > C > C,X21: nat,X22: huffma16452318e_tree @ A,X23: huffma16452318e_tree @ A] :
      ( ( huffma577982705c_tree @ A @ C @ F1 @ F2 @ ( huffma1759677307erNode @ A @ X21 @ X22 @ X23 ) )
      = ( F2 @ X21 @ X22 @ X23 @ ( huffma577982705c_tree @ A @ C @ F1 @ F2 @ X22 ) @ ( huffma577982705c_tree @ A @ C @ F1 @ F2 @ X23 ) ) ) ).

% tree.simps(8)
thf(fact_15_sibling_Osimps_I4_J,axiom,
    ! [A: $tType,A2: A,T_1: huffma16452318e_tree @ A,W: nat,V: nat,Va: huffma16452318e_tree @ A,Vb: huffma16452318e_tree @ A] :
      ( ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T_1 ) )
       => ( ( huffma943100115ibling @ A @ ( huffma1759677307erNode @ A @ W @ T_1 @ ( huffma1759677307erNode @ A @ V @ Va @ Vb ) ) @ A2 )
          = ( huffma943100115ibling @ A @ T_1 @ A2 ) ) )
      & ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T_1 ) )
       => ( ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ ( huffma1759677307erNode @ A @ V @ Va @ Vb ) ) )
           => ( ( huffma943100115ibling @ A @ ( huffma1759677307erNode @ A @ W @ T_1 @ ( huffma1759677307erNode @ A @ V @ Va @ Vb ) ) @ A2 )
              = ( huffma943100115ibling @ A @ ( huffma1759677307erNode @ A @ V @ Va @ Vb ) @ A2 ) ) )
          & ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ ( huffma1759677307erNode @ A @ V @ Va @ Vb ) ) )
           => ( ( huffma943100115ibling @ A @ ( huffma1759677307erNode @ A @ W @ T_1 @ ( huffma1759677307erNode @ A @ V @ Va @ Vb ) ) @ A2 )
              = A2 ) ) ) ) ) ).

% sibling.simps(4)
thf(fact_16_sibling_Osimps_I3_J,axiom,
    ! [A: $tType,A2: A,V: nat,Va: huffma16452318e_tree @ A,Vb: huffma16452318e_tree @ A,W: nat,T_2: huffma16452318e_tree @ A] :
      ( ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ ( huffma1759677307erNode @ A @ V @ Va @ Vb ) ) )
       => ( ( huffma943100115ibling @ A @ ( huffma1759677307erNode @ A @ W @ ( huffma1759677307erNode @ A @ V @ Va @ Vb ) @ T_2 ) @ A2 )
          = ( huffma943100115ibling @ A @ ( huffma1759677307erNode @ A @ V @ Va @ Vb ) @ A2 ) ) )
      & ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ ( huffma1759677307erNode @ A @ V @ Va @ Vb ) ) )
       => ( ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T_2 ) )
           => ( ( huffma943100115ibling @ A @ ( huffma1759677307erNode @ A @ W @ ( huffma1759677307erNode @ A @ V @ Va @ Vb ) @ T_2 ) @ A2 )
              = ( huffma943100115ibling @ A @ T_2 @ A2 ) ) )
          & ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T_2 ) )
           => ( ( huffma943100115ibling @ A @ ( huffma1759677307erNode @ A @ W @ ( huffma1759677307erNode @ A @ V @ Va @ Vb ) @ T_2 ) @ A2 )
              = A2 ) ) ) ) ) ).

% sibling.simps(3)
thf(fact_17_tree_Opred__inject_I2_J,axiom,
    ! [A: $tType,P: A > $o,A2: nat,Aa: huffma16452318e_tree @ A,Ab: huffma16452318e_tree @ A] :
      ( ( huffma1727904060d_tree @ A @ P @ ( huffma1759677307erNode @ A @ A2 @ Aa @ Ab ) )
      = ( ( huffma1727904060d_tree @ A @ P @ Aa )
        & ( huffma1727904060d_tree @ A @ P @ Ab ) ) ) ).

% tree.pred_inject(2)
thf(fact_18_sibling__sibling__id,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( huffma943100115ibling @ A @ T @ ( huffma943100115ibling @ A @ T @ A2 ) )
        = A2 ) ) ).

% sibling_sibling_id
thf(fact_19_consistent__swapLeaves,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,W_a: nat,A2: A,W_b: nat,B2: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( huffma1050891809istent @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B2 ) ) ) ).

% consistent_swapLeaves
thf(fact_20_sibling__reciprocal,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B2: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( ( huffma943100115ibling @ A @ T @ A2 )
          = B2 )
       => ( ( huffma943100115ibling @ A @ T @ B2 )
          = A2 ) ) ) ).

% sibling_reciprocal
thf(fact_21_tree_Oinject_I1_J,axiom,
    ! [A: $tType,X11: nat,X12: A,Y11: nat,Y12: A] :
      ( ( ( huffma1554276827e_Leaf @ A @ X11 @ X12 )
        = ( huffma1554276827e_Leaf @ A @ Y11 @ Y12 ) )
      = ( ( X11 = Y11 )
        & ( X12 = Y12 ) ) ) ).

% tree.inject(1)
thf(fact_22_notin__alphabet__imp__sibling__id,axiom,
    ! [A: $tType,A2: A,T: huffma16452318e_tree @ A] :
      ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
     => ( ( huffma943100115ibling @ A @ T @ A2 )
        = A2 ) ) ).

% notin_alphabet_imp_sibling_id
thf(fact_23_swapLeaves__id__when__notin__alphabet,axiom,
    ! [A: $tType,A2: A,T: huffma16452318e_tree @ A,W: nat,W2: nat] :
      ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
     => ( ( huffma2094459102Leaves @ A @ T @ W @ A2 @ W2 @ A2 )
        = T ) ) ).

% swapLeaves_id_when_notin_alphabet
thf(fact_24_tree_Opred__inject_I1_J,axiom,
    ! [A: $tType,P: A > $o,A2: nat,Aa: A] :
      ( ( huffma1727904060d_tree @ A @ P @ ( huffma1554276827e_Leaf @ A @ A2 @ Aa ) )
      = ( P @ Aa ) ) ).

% tree.pred_inject(1)
thf(fact_25_tree_Osimps_I7_J,axiom,
    ! [C: $tType,A: $tType,F1: nat > A > C,F2: nat > ( huffma16452318e_tree @ A ) > ( huffma16452318e_tree @ A ) > C > C > C,X11: nat,X12: A] :
      ( ( huffma577982705c_tree @ A @ C @ F1 @ F2 @ ( huffma1554276827e_Leaf @ A @ X11 @ X12 ) )
      = ( F1 @ X11 @ X12 ) ) ).

% tree.simps(7)
thf(fact_26_tree_Osimps_I5_J,axiom,
    ! [B: $tType,A: $tType,F1: nat > A > B,F2: nat > ( huffma16452318e_tree @ A ) > ( huffma16452318e_tree @ A ) > B,X11: nat,X12: A] :
      ( ( huffma570615019e_tree @ A @ B @ F1 @ F2 @ ( huffma1554276827e_Leaf @ A @ X11 @ X12 ) )
      = ( F1 @ X11 @ X12 ) ) ).

% tree.simps(5)
thf(fact_27_height_Osimps_I1_J,axiom,
    ! [A: $tType,W: nat,A2: A] :
      ( ( huffma1554076246height @ A @ ( huffma1554276827e_Leaf @ A @ W @ A2 ) )
      = ( zero_zero @ nat ) ) ).

% height.simps(1)
thf(fact_28_consistent_Osimps_I1_J,axiom,
    ! [A: $tType,W: nat,A2: A] : ( huffma1050891809istent @ A @ ( huffma1554276827e_Leaf @ A @ W @ A2 ) ) ).

% consistent.simps(1)
thf(fact_29_cachedWeight_Osimps_I1_J,axiom,
    ! [A: $tType,W: nat,A2: A] :
      ( ( huffma787811817Weight @ A @ ( huffma1554276827e_Leaf @ A @ W @ A2 ) )
      = W ) ).

% cachedWeight.simps(1)
thf(fact_30_exists__in__alphabet,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A] :
    ? [A3: A] : ( member @ A @ A3 @ ( huffma505251170phabet @ A @ T ) ) ).

% exists_in_alphabet
thf(fact_31_sibling_Oinduct,axiom,
    ! [A: $tType,P: ( huffma16452318e_tree @ A ) > A > $o,A0: huffma16452318e_tree @ A,A1: A] :
      ( ! [W_b2: nat,B3: A,X1: A] : ( P @ ( huffma1554276827e_Leaf @ A @ W_b2 @ B3 ) @ X1 )
     => ( ! [W3: nat,W_b2: nat,B3: A,W_c2: nat,C3: A,X1: A] : ( P @ ( huffma1759677307erNode @ A @ W3 @ ( huffma1554276827e_Leaf @ A @ W_b2 @ B3 ) @ ( huffma1554276827e_Leaf @ A @ W_c2 @ C3 ) ) @ X1 )
       => ( ! [W3: nat,V2: nat,Va2: huffma16452318e_tree @ A,Vb2: huffma16452318e_tree @ A,T_22: huffma16452318e_tree @ A,A3: A] :
              ( ( ( member @ A @ A3 @ ( huffma505251170phabet @ A @ ( huffma1759677307erNode @ A @ V2 @ Va2 @ Vb2 ) ) )
               => ( P @ ( huffma1759677307erNode @ A @ V2 @ Va2 @ Vb2 ) @ A3 ) )
             => ( ( ~ ( member @ A @ A3 @ ( huffma505251170phabet @ A @ ( huffma1759677307erNode @ A @ V2 @ Va2 @ Vb2 ) ) )
                 => ( ( member @ A @ A3 @ ( huffma505251170phabet @ A @ T_22 ) )
                   => ( P @ T_22 @ A3 ) ) )
               => ( P @ ( huffma1759677307erNode @ A @ W3 @ ( huffma1759677307erNode @ A @ V2 @ Va2 @ Vb2 ) @ T_22 ) @ A3 ) ) )
         => ( ! [W3: nat,T_12: huffma16452318e_tree @ A,V2: nat,Va2: huffma16452318e_tree @ A,Vb2: huffma16452318e_tree @ A,A3: A] :
                ( ( ( member @ A @ A3 @ ( huffma505251170phabet @ A @ T_12 ) )
                 => ( P @ T_12 @ A3 ) )
               => ( ( ~ ( member @ A @ A3 @ ( huffma505251170phabet @ A @ T_12 ) )
                   => ( ( member @ A @ A3 @ ( huffma505251170phabet @ A @ ( huffma1759677307erNode @ A @ V2 @ Va2 @ Vb2 ) ) )
                     => ( P @ ( huffma1759677307erNode @ A @ V2 @ Va2 @ Vb2 ) @ A3 ) ) )
                 => ( P @ ( huffma1759677307erNode @ A @ W3 @ T_12 @ ( huffma1759677307erNode @ A @ V2 @ Va2 @ Vb2 ) ) @ A3 ) ) )
           => ( P @ A0 @ A1 ) ) ) ) ) ).

% sibling.induct
thf(fact_32_in__alphabet__imp__sibling__in__alphabet,axiom,
    ! [A: $tType,A2: A,T: huffma16452318e_tree @ A] :
      ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
     => ( member @ A @ ( huffma943100115ibling @ A @ T @ A2 ) @ ( huffma505251170phabet @ A @ T ) ) ) ).

% in_alphabet_imp_sibling_in_alphabet
thf(fact_33_sibling__ne__imp__sibling__in__alphabet,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( ( huffma943100115ibling @ A @ T @ A2 )
       != A2 )
     => ( member @ A @ ( huffma943100115ibling @ A @ T @ A2 ) @ ( huffma505251170phabet @ A @ T ) ) ) ).

% sibling_ne_imp_sibling_in_alphabet
thf(fact_34_tree_Oexhaust,axiom,
    ! [A: $tType,Y: huffma16452318e_tree @ A] :
      ( ! [X112: nat,X122: A] :
          ( Y
         != ( huffma1554276827e_Leaf @ A @ X112 @ X122 ) )
     => ~ ! [X212: nat,X222: huffma16452318e_tree @ A,X232: huffma16452318e_tree @ A] :
            ( Y
           != ( huffma1759677307erNode @ A @ X212 @ X222 @ X232 ) ) ) ).

% tree.exhaust
thf(fact_35_tree_Oinduct,axiom,
    ! [A: $tType,P: ( huffma16452318e_tree @ A ) > $o,Tree: huffma16452318e_tree @ A] :
      ( ! [X1: nat,X2: A] : ( P @ ( huffma1554276827e_Leaf @ A @ X1 @ X2 ) )
     => ( ! [X1: nat,X2: huffma16452318e_tree @ A,X3: huffma16452318e_tree @ A] :
            ( ( P @ X2 )
           => ( ( P @ X3 )
             => ( P @ ( huffma1759677307erNode @ A @ X1 @ X2 @ X3 ) ) ) )
       => ( P @ Tree ) ) ) ).

% tree.induct
thf(fact_36_tree_Odistinct_I1_J,axiom,
    ! [A: $tType,X11: nat,X12: A,X21: nat,X22: huffma16452318e_tree @ A,X23: huffma16452318e_tree @ A] :
      ( ( huffma1554276827e_Leaf @ A @ X11 @ X12 )
     != ( huffma1759677307erNode @ A @ X21 @ X22 @ X23 ) ) ).

% tree.distinct(1)
thf(fact_37_sibling_Osimps_I1_J,axiom,
    ! [A: $tType,W_b: nat,B2: A,A2: A] :
      ( ( huffma943100115ibling @ A @ ( huffma1554276827e_Leaf @ A @ W_b @ B2 ) @ A2 )
      = A2 ) ).

% sibling.simps(1)
thf(fact_38_swapLeaves_Osimps_I1_J,axiom,
    ! [A: $tType,C2: A,A2: A,W_c: nat,W_a: nat,W_b: nat,B2: A] :
      ( ( ( C2 = A2 )
       => ( ( huffma2094459102Leaves @ A @ ( huffma1554276827e_Leaf @ A @ W_c @ C2 ) @ W_a @ A2 @ W_b @ B2 )
          = ( huffma1554276827e_Leaf @ A @ W_b @ B2 ) ) )
      & ( ( C2 != A2 )
       => ( ( ( C2 = B2 )
           => ( ( huffma2094459102Leaves @ A @ ( huffma1554276827e_Leaf @ A @ W_c @ C2 ) @ W_a @ A2 @ W_b @ B2 )
              = ( huffma1554276827e_Leaf @ A @ W_a @ A2 ) ) )
          & ( ( C2 != B2 )
           => ( ( huffma2094459102Leaves @ A @ ( huffma1554276827e_Leaf @ A @ W_c @ C2 ) @ W_a @ A2 @ W_b @ B2 )
              = ( huffma1554276827e_Leaf @ A @ W_c @ C2 ) ) ) ) ) ) ).

% swapLeaves.simps(1)
thf(fact_39_height__0__imp__cachedWeight__eq__weight,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A] :
      ( ( ( huffma1554076246height @ A @ T )
        = ( zero_zero @ nat ) )
     => ( ( huffma787811817Weight @ A @ T )
        = ( huffma691733767weight @ A @ T ) ) ) ).

% height_0_imp_cachedWeight_eq_weight
thf(fact_40_freq__swapLeaves,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B2: A,W_a: nat,W_b: nat] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( A2 != B2 )
       => ( ( huffma854352999e_freq @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B2 ) )
          = ( ^ [C4: A] : ( if @ nat @ ( C4 = A2 ) @ ( if @ nat @ ( member @ A @ B2 @ ( huffma505251170phabet @ A @ T ) ) @ W_a @ ( zero_zero @ nat ) ) @ ( if @ nat @ ( C4 = B2 ) @ ( if @ nat @ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) ) @ W_b @ ( zero_zero @ nat ) ) @ ( huffma854352999e_freq @ A @ T @ C4 ) ) ) ) ) ) ) ).

% freq_swapLeaves
thf(fact_41_height__gt__0__notin__alphabet__imp__sibling__right,axiom,
    ! [A: $tType,T_2: huffma16452318e_tree @ A,A2: A,T_1: huffma16452318e_tree @ A,W: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( huffma1554076246height @ A @ T_2 ) )
     => ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T_1 ) )
       => ( ( huffma943100115ibling @ A @ ( huffma1759677307erNode @ A @ W @ T_1 @ T_2 ) @ A2 )
          = ( huffma943100115ibling @ A @ T_2 @ A2 ) ) ) ) ).

% height_gt_0_notin_alphabet_imp_sibling_right
thf(fact_42_height__gt__0__notin__alphabet__imp__sibling__left,axiom,
    ! [A: $tType,T_1: huffma16452318e_tree @ A,A2: A,W: nat,T_2: huffma16452318e_tree @ A] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( huffma1554076246height @ A @ T_1 ) )
     => ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T_1 ) )
       => ( ( huffma943100115ibling @ A @ ( huffma1759677307erNode @ A @ W @ T_1 @ T_2 ) @ A2 )
          = ( huffma943100115ibling @ A @ T_2 @ A2 ) ) ) ) ).

% height_gt_0_notin_alphabet_imp_sibling_left
thf(fact_43_height__gt__0__in__alphabet__imp__sibling__right,axiom,
    ! [A: $tType,T_2: huffma16452318e_tree @ A,A2: A,T_1: huffma16452318e_tree @ A,W: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( huffma1554076246height @ A @ T_2 ) )
     => ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T_1 ) )
       => ( ( huffma943100115ibling @ A @ ( huffma1759677307erNode @ A @ W @ T_1 @ T_2 ) @ A2 )
          = ( huffma943100115ibling @ A @ T_1 @ A2 ) ) ) ) ).

% height_gt_0_in_alphabet_imp_sibling_right
thf(fact_44_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P ) )
      = ( P @ A2 ) ) ).

% mem_Collect_eq
thf(fact_45_Collect__mem__eq,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( collect @ A
        @ ^ [X: A] : ( member @ A @ X @ A4 ) )
      = A4 ) ).

% Collect_mem_eq
thf(fact_46_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X4: A] :
          ( ( P @ X4 )
          = ( Q @ X4 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_47_ext,axiom,
    ! [B: $tType,A: $tType,F: A > B,G: A > B] :
      ( ! [X4: A] :
          ( ( F @ X4 )
          = ( G @ X4 ) )
     => ( F = G ) ) ).

% ext
thf(fact_48_height__gt__0__in__alphabet__imp__sibling__left,axiom,
    ! [A: $tType,T_1: huffma16452318e_tree @ A,A2: A,W: nat,T_2: huffma16452318e_tree @ A] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( huffma1554076246height @ A @ T_1 ) )
     => ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T_1 ) )
       => ( ( huffma943100115ibling @ A @ ( huffma1759677307erNode @ A @ W @ T_1 @ T_2 ) @ A2 )
          = ( huffma943100115ibling @ A @ T_1 @ A2 ) ) ) ) ).

% height_gt_0_in_alphabet_imp_sibling_left
thf(fact_49_either__height__gt__0__imp__sibling,axiom,
    ! [A: $tType,T_1: huffma16452318e_tree @ A,T_2: huffma16452318e_tree @ A,A2: A,W: nat] :
      ( ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( huffma1554076246height @ A @ T_1 ) )
        | ( ord_less @ nat @ ( zero_zero @ nat ) @ ( huffma1554076246height @ A @ T_2 ) ) )
     => ( ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T_1 ) )
         => ( ( huffma943100115ibling @ A @ ( huffma1759677307erNode @ A @ W @ T_1 @ T_2 ) @ A2 )
            = ( huffma943100115ibling @ A @ T_1 @ A2 ) ) )
        & ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T_1 ) )
         => ( ( huffma943100115ibling @ A @ ( huffma1759677307erNode @ A @ W @ T_1 @ T_2 ) @ A2 )
            = ( huffma943100115ibling @ A @ T_2 @ A2 ) ) ) ) ) ).

% either_height_gt_0_imp_sibling
thf(fact_50_exists__at__height,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A] :
      ( ( huffma1050891809istent @ A @ T )
     => ? [X4: A] :
          ( ( member @ A @ X4 @ ( huffma505251170phabet @ A @ T ) )
          & ( ( huffma223349076_depth @ A @ T @ X4 )
            = ( huffma1554076246height @ A @ T ) ) ) ) ).

% exists_at_height
thf(fact_51_height__gt__0__alphabet__eq__imp__height__gt__0,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,U: huffma16452318e_tree @ A] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( huffma1554076246height @ A @ T ) )
     => ( ( huffma1050891809istent @ A @ T )
       => ( ( ( huffma505251170phabet @ A @ T )
            = ( huffma505251170phabet @ A @ U ) )
         => ( ord_less @ nat @ ( zero_zero @ nat ) @ ( huffma1554076246height @ A @ U ) ) ) ) ) ).

% height_gt_0_alphabet_eq_imp_height_gt_0
thf(fact_52_not__gr__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type @ A ) )
     => ! [N: A] :
          ( ( ~ ( ord_less @ A @ ( zero_zero @ A ) @ N ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% not_gr_zero
thf(fact_53_notin__alphabet__imp__freq__0,axiom,
    ! [A: $tType,A2: A,T: huffma16452318e_tree @ A] :
      ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
     => ( ( huffma854352999e_freq @ A @ T @ A2 )
        = ( zero_zero @ nat ) ) ) ).

% notin_alphabet_imp_freq_0
thf(fact_54_depth__sibling,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( huffma223349076_depth @ A @ T @ ( huffma943100115ibling @ A @ T @ A2 ) )
        = ( huffma223349076_depth @ A @ T @ A2 ) ) ) ).

% depth_sibling
thf(fact_55_swapLeaves__id,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( huffma2094459102Leaves @ A @ T @ ( huffma854352999e_freq @ A @ T @ A2 ) @ A2 @ ( huffma854352999e_freq @ A @ T @ A2 ) @ A2 )
        = T ) ) ).

% swapLeaves_id
thf(fact_56_depth__swapLeaves__neither,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,C2: A,A2: A,B2: A,W_a: nat,W_b: nat] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( C2 != A2 )
       => ( ( C2 != B2 )
         => ( ( huffma223349076_depth @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B2 ) @ C2 )
            = ( huffma223349076_depth @ A @ T @ C2 ) ) ) ) ) ).

% depth_swapLeaves_neither
thf(fact_57_zero__less__iff__neq__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type @ A ) )
     => ! [N: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ N )
          = ( N
           != ( zero_zero @ A ) ) ) ) ).

% zero_less_iff_neq_zero
thf(fact_58_gr__implies__not__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type @ A ) )
     => ! [M: A,N: A] :
          ( ( ord_less @ A @ M @ N )
         => ( N
           != ( zero_zero @ A ) ) ) ) ).

% gr_implies_not_zero
thf(fact_59_not__less__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type @ A ) )
     => ! [N: A] :
          ~ ( ord_less @ A @ N @ ( zero_zero @ A ) ) ) ).

% not_less_zero
thf(fact_60_gr__zeroI,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type @ A ) )
     => ! [N: A] :
          ( ( N
           != ( zero_zero @ A ) )
         => ( ord_less @ A @ ( zero_zero @ A ) @ N ) ) ) ).

% gr_zeroI
thf(fact_61_weight_Osimps_I1_J,axiom,
    ! [A: $tType,W: nat,A2: A] :
      ( ( huffma691733767weight @ A @ ( huffma1554276827e_Leaf @ A @ W @ A2 ) )
      = W ) ).

% weight.simps(1)
thf(fact_62_freq_Osimps_I1_J,axiom,
    ! [A: $tType,W: nat,A2: A] :
      ( ( huffma854352999e_freq @ A @ ( huffma1554276827e_Leaf @ A @ W @ A2 ) )
      = ( ^ [B4: A] : ( if @ nat @ ( B4 = A2 ) @ W @ ( zero_zero @ nat ) ) ) ) ).

% freq.simps(1)
thf(fact_63_depth_Osimps_I1_J,axiom,
    ! [A: $tType,W: nat,B2: A,A2: A] :
      ( ( huffma223349076_depth @ A @ ( huffma1554276827e_Leaf @ A @ W @ B2 ) @ A2 )
      = ( zero_zero @ nat ) ) ).

% depth.simps(1)
thf(fact_64_depth__height__imp__sibling__ne,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( ( huffma223349076_depth @ A @ T @ A2 )
          = ( huffma1554076246height @ A @ T ) )
       => ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( huffma1554076246height @ A @ T ) )
         => ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
           => ( ( huffma943100115ibling @ A @ T @ A2 )
             != A2 ) ) ) ) ) ).

% depth_height_imp_sibling_ne
thf(fact_65_zero__reorient,axiom,
    ! [A: $tType] :
      ( ( zero @ A @ ( type @ A ) )
     => ! [X5: A] :
          ( ( ( zero_zero @ A )
            = X5 )
          = ( X5
            = ( zero_zero @ A ) ) ) ) ).

% zero_reorient
thf(fact_66_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N
       != ( zero_zero @ nat ) )
      = ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ).

% neq0_conv
thf(fact_67_infinite__descent0__measure,axiom,
    ! [A: $tType,V3: A > nat,P: A > $o,X5: A] :
      ( ! [X4: A] :
          ( ( ( V3 @ X4 )
            = ( zero_zero @ nat ) )
         => ( P @ X4 ) )
     => ( ! [X4: A] :
            ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( V3 @ X4 ) )
           => ( ~ ( P @ X4 )
             => ? [Y2: A] :
                  ( ( ord_less @ nat @ ( V3 @ Y2 ) @ ( V3 @ X4 ) )
                  & ~ ( P @ Y2 ) ) ) )
       => ( P @ X5 ) ) ) ).

% infinite_descent0_measure
thf(fact_68_less__nat__zero__code,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ ( zero_zero @ nat ) ) ).

% less_nat_zero_code
thf(fact_69_infinite__descent0,axiom,
    ! [P: nat > $o,N: nat] :
      ( ( P @ ( zero_zero @ nat ) )
     => ( ! [N2: nat] :
            ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N2 )
           => ( ~ ( P @ N2 )
             => ? [M2: nat] :
                  ( ( ord_less @ nat @ M2 @ N2 )
                  & ~ ( P @ M2 ) ) ) )
       => ( P @ N ) ) ) ).

% infinite_descent0
thf(fact_70_gr__implies__not0,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( N
       != ( zero_zero @ nat ) ) ) ).

% gr_implies_not0
thf(fact_71_less__zeroE,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ ( zero_zero @ nat ) ) ).

% less_zeroE
thf(fact_72_not__less0,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ ( zero_zero @ nat ) ) ).

% not_less0
thf(fact_73_not__gr0,axiom,
    ! [N: nat] :
      ( ( ~ ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) )
      = ( N
        = ( zero_zero @ nat ) ) ) ).

% not_gr0
thf(fact_74_nat__neq__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( M != N )
      = ( ( ord_less @ nat @ M @ N )
        | ( ord_less @ nat @ N @ M ) ) ) ).

% nat_neq_iff
thf(fact_75_less__not__refl,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ N ) ).

% less_not_refl
thf(fact_76_less__not__refl2,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less @ nat @ N @ M )
     => ( M != N ) ) ).

% less_not_refl2
thf(fact_77_less__not__refl3,axiom,
    ! [S: nat,T: nat] :
      ( ( ord_less @ nat @ S @ T )
     => ( S != T ) ) ).

% less_not_refl3
thf(fact_78_measure__induct,axiom,
    ! [A: $tType,F: A > nat,P: A > $o,A2: A] :
      ( ! [X4: A] :
          ( ! [Y2: A] :
              ( ( ord_less @ nat @ ( F @ Y2 ) @ ( F @ X4 ) )
             => ( P @ Y2 ) )
         => ( P @ X4 ) )
     => ( P @ A2 ) ) ).

% measure_induct
thf(fact_79_less__irrefl__nat,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ N ) ).

% less_irrefl_nat
thf(fact_80_nat__less__induct,axiom,
    ! [P: nat > $o,N: nat] :
      ( ! [N2: nat] :
          ( ! [M2: nat] :
              ( ( ord_less @ nat @ M2 @ N2 )
             => ( P @ M2 ) )
         => ( P @ N2 ) )
     => ( P @ N ) ) ).

% nat_less_induct
thf(fact_81_infinite__descent,axiom,
    ! [P: nat > $o,N: nat] :
      ( ! [N2: nat] :
          ( ~ ( P @ N2 )
         => ? [M2: nat] :
              ( ( ord_less @ nat @ M2 @ N2 )
              & ~ ( P @ M2 ) ) )
     => ( P @ N ) ) ).

% infinite_descent
thf(fact_82_linorder__neqE__nat,axiom,
    ! [X5: nat,Y: nat] :
      ( ( X5 != Y )
     => ( ~ ( ord_less @ nat @ X5 @ Y )
       => ( ord_less @ nat @ Y @ X5 ) ) ) ).

% linorder_neqE_nat
thf(fact_83_measure__induct__rule,axiom,
    ! [A: $tType,F: A > nat,P: A > $o,A2: A] :
      ( ! [X4: A] :
          ( ! [Y2: A] :
              ( ( ord_less @ nat @ ( F @ Y2 ) @ ( F @ X4 ) )
             => ( P @ Y2 ) )
         => ( P @ X4 ) )
     => ( P @ A2 ) ) ).

% measure_induct_rule
thf(fact_84_infinite__descent__measure,axiom,
    ! [A: $tType,P: A > $o,V3: A > nat,X5: A] :
      ( ! [X4: A] :
          ( ~ ( P @ X4 )
         => ? [Y2: A] :
              ( ( ord_less @ nat @ ( V3 @ Y2 ) @ ( V3 @ X4 ) )
              & ~ ( P @ Y2 ) ) )
     => ( P @ X5 ) ) ).

% infinite_descent_measure
thf(fact_85_gr0I,axiom,
    ! [N: nat] :
      ( ( N
       != ( zero_zero @ nat ) )
     => ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ).

% gr0I
thf(fact_86_less__numeral__extra_I3_J,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ~ ( ord_less @ A @ ( zero_zero @ A ) @ ( zero_zero @ A ) ) ) ).

% less_numeral_extra(3)
thf(fact_87_weight__swapLeaves,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B2: A,W_a: nat,W_b: nat] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( A2 != B2 )
       => ( ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
           => ( ( ( member @ A @ B2 @ ( huffma505251170phabet @ A @ T ) )
               => ( ( plus_plus @ nat @ ( plus_plus @ nat @ ( huffma691733767weight @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B2 ) ) @ ( huffma854352999e_freq @ A @ T @ A2 ) ) @ ( huffma854352999e_freq @ A @ T @ B2 ) )
                  = ( plus_plus @ nat @ ( plus_plus @ nat @ ( huffma691733767weight @ A @ T ) @ W_a ) @ W_b ) ) )
              & ( ~ ( member @ A @ B2 @ ( huffma505251170phabet @ A @ T ) )
               => ( ( plus_plus @ nat @ ( huffma691733767weight @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B2 ) ) @ ( huffma854352999e_freq @ A @ T @ A2 ) )
                  = ( plus_plus @ nat @ ( huffma691733767weight @ A @ T ) @ W_b ) ) ) ) )
          & ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
           => ( ( ( member @ A @ B2 @ ( huffma505251170phabet @ A @ T ) )
               => ( ( plus_plus @ nat @ ( huffma691733767weight @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B2 ) ) @ ( huffma854352999e_freq @ A @ T @ B2 ) )
                  = ( plus_plus @ nat @ ( huffma691733767weight @ A @ T ) @ W_a ) ) )
              & ( ~ ( member @ A @ B2 @ ( huffma505251170phabet @ A @ T ) )
               => ( ( huffma691733767weight @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B2 ) )
                  = ( huffma691733767weight @ A @ T ) ) ) ) ) ) ) ) ).

% weight_swapLeaves
thf(fact_88_height__0__imp__cost__0,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A] :
      ( ( ( huffma1554076246height @ A @ T )
        = ( zero_zero @ nat ) )
     => ( ( huffma636208924e_cost @ A @ T )
        = ( zero_zero @ nat ) ) ) ).

% height_0_imp_cost_0
thf(fact_89_of__nat__0__less__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ! [N: nat] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( semiring_1_of_nat @ A @ N ) )
          = ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ) ).

% of_nat_0_less_iff
thf(fact_90_cost_Osimps_I1_J,axiom,
    ! [A: $tType,W: nat,A2: A] :
      ( ( huffma636208924e_cost @ A @ ( huffma1554276827e_Leaf @ A @ W @ A2 ) )
      = ( zero_zero @ nat ) ) ).

% cost.simps(1)
thf(fact_91_zero__natural_Orsp,axiom,
    ( ( zero_zero @ nat )
    = ( zero_zero @ nat ) ) ).

% zero_natural.rsp
thf(fact_92_add__left__cancel,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ( plus_plus @ A @ A2 @ B2 )
            = ( plus_plus @ A @ A2 @ C2 ) )
          = ( B2 = C2 ) ) ) ).

% add_left_cancel
thf(fact_93_add__right__cancel,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type @ A ) )
     => ! [B2: A,A2: A,C2: A] :
          ( ( ( plus_plus @ A @ B2 @ A2 )
            = ( plus_plus @ A @ C2 @ A2 ) )
          = ( B2 = C2 ) ) ) ).

% add_right_cancel
thf(fact_94_of__nat__eq__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type @ A ) )
     => ! [M: nat,N: nat] :
          ( ( ( semiring_1_of_nat @ A @ M )
            = ( semiring_1_of_nat @ A @ N ) )
          = ( M = N ) ) ) ).

% of_nat_eq_iff
thf(fact_95_add__cancel__right__right,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type @ A ) )
     => ! [A2: A,B2: A] :
          ( ( A2
            = ( plus_plus @ A @ A2 @ B2 ) )
          = ( B2
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_right_right
thf(fact_96_add__cancel__right__left,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type @ A ) )
     => ! [A2: A,B2: A] :
          ( ( A2
            = ( plus_plus @ A @ B2 @ A2 ) )
          = ( B2
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_right_left
thf(fact_97_add__cancel__left__right,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ( plus_plus @ A @ A2 @ B2 )
            = A2 )
          = ( B2
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_left_right
thf(fact_98_add__cancel__left__left,axiom,
    ! [A: $tType] :
      ( ( cancel1352612707id_add @ A @ ( type @ A ) )
     => ! [B2: A,A2: A] :
          ( ( ( plus_plus @ A @ B2 @ A2 )
            = A2 )
          = ( B2
            = ( zero_zero @ A ) ) ) ) ).

% add_cancel_left_left
thf(fact_99_double__zero__sym,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( ( zero_zero @ A )
            = ( plus_plus @ A @ A2 @ A2 ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% double_zero_sym
thf(fact_100_double__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( ( plus_plus @ A @ A2 @ A2 )
            = ( zero_zero @ A ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% double_zero
thf(fact_101_add_Oright__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_add @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% add.right_neutral
thf(fact_102_add_Oleft__neutral,axiom,
    ! [A: $tType] :
      ( ( monoid_add @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% add.left_neutral
thf(fact_103_add__less__cancel__right,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type @ A ) )
     => ! [A2: A,C2: A,B2: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ A2 @ C2 ) @ ( plus_plus @ A @ B2 @ C2 ) )
          = ( ord_less @ A @ A2 @ B2 ) ) ) ).

% add_less_cancel_right
thf(fact_104_add__less__cancel__left,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type @ A ) )
     => ! [C2: A,A2: A,B2: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ C2 @ A2 ) @ ( plus_plus @ A @ C2 @ B2 ) )
          = ( ord_less @ A @ A2 @ B2 ) ) ) ).

% add_less_cancel_left
thf(fact_105_add__is__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ( plus_plus @ nat @ M @ N )
        = ( zero_zero @ nat ) )
      = ( ( M
          = ( zero_zero @ nat ) )
        & ( N
          = ( zero_zero @ nat ) ) ) ) ).

% add_is_0
thf(fact_106_Nat_Oadd__0__right,axiom,
    ! [M: nat] :
      ( ( plus_plus @ nat @ M @ ( zero_zero @ nat ) )
      = M ) ).

% Nat.add_0_right
thf(fact_107_nat__add__left__cancel__less,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less @ nat @ ( plus_plus @ nat @ K @ M ) @ ( plus_plus @ nat @ K @ N ) )
      = ( ord_less @ nat @ M @ N ) ) ).

% nat_add_left_cancel_less
thf(fact_108_add__less__same__cancel1,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type @ A ) )
     => ! [B2: A,A2: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ B2 @ A2 ) @ B2 )
          = ( ord_less @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% add_less_same_cancel1
thf(fact_109_add__less__same__cancel2,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ A2 @ B2 ) @ B2 )
          = ( ord_less @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% add_less_same_cancel2
thf(fact_110_less__add__same__cancel1,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ A2 @ ( plus_plus @ A @ A2 @ B2 ) )
          = ( ord_less @ A @ ( zero_zero @ A ) @ B2 ) ) ) ).

% less_add_same_cancel1
thf(fact_111_less__add__same__cancel2,axiom,
    ! [A: $tType] :
      ( ( ordere516151231imp_le @ A @ ( type @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ A2 @ ( plus_plus @ A @ B2 @ A2 ) )
          = ( ord_less @ A @ ( zero_zero @ A ) @ B2 ) ) ) ).

% less_add_same_cancel2
thf(fact_112_double__add__less__zero__iff__single__add__less__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ A2 @ A2 ) @ ( zero_zero @ A ) )
          = ( ord_less @ A @ A2 @ ( zero_zero @ A ) ) ) ) ).

% double_add_less_zero_iff_single_add_less_zero
thf(fact_113_zero__less__double__add__iff__zero__less__single__add,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( plus_plus @ A @ A2 @ A2 ) )
          = ( ord_less @ A @ ( zero_zero @ A ) @ A2 ) ) ) ).

% zero_less_double_add_iff_zero_less_single_add
thf(fact_114_of__nat__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type @ A ) )
     => ! [M: nat] :
          ( ( ( semiring_1_of_nat @ A @ M )
            = ( zero_zero @ A ) )
          = ( M
            = ( zero_zero @ nat ) ) ) ) ).

% of_nat_eq_0_iff
thf(fact_115_of__nat__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A @ ( type @ A ) )
     => ! [N: nat] :
          ( ( ( zero_zero @ A )
            = ( semiring_1_of_nat @ A @ N ) )
          = ( ( zero_zero @ nat )
            = N ) ) ) ).

% of_nat_0_eq_iff
thf(fact_116_of__nat__0,axiom,
    ! [A: $tType] :
      ( ( semiring_1 @ A @ ( type @ A ) )
     => ( ( semiring_1_of_nat @ A @ ( zero_zero @ nat ) )
        = ( zero_zero @ A ) ) ) ).

% of_nat_0
thf(fact_117_of__nat__less__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ! [M: nat,N: nat] :
          ( ( ord_less @ A @ ( semiring_1_of_nat @ A @ M ) @ ( semiring_1_of_nat @ A @ N ) )
          = ( ord_less @ nat @ M @ N ) ) ) ).

% of_nat_less_iff
thf(fact_118_add__gr__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( plus_plus @ nat @ M @ N ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ M )
        | ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ) ).

% add_gr_0
thf(fact_119_of__nat__add,axiom,
    ! [A: $tType] :
      ( ( semiring_1 @ A @ ( type @ A ) )
     => ! [M: nat,N: nat] :
          ( ( semiring_1_of_nat @ A @ ( plus_plus @ nat @ M @ N ) )
          = ( plus_plus @ A @ ( semiring_1_of_nat @ A @ M ) @ ( semiring_1_of_nat @ A @ N ) ) ) ) ).

% of_nat_add
thf(fact_120_nat__add__left__cancel,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ( plus_plus @ nat @ K @ M )
        = ( plus_plus @ nat @ K @ N ) )
      = ( M = N ) ) ).

% nat_add_left_cancel
thf(fact_121_nat__add__right__cancel,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ( plus_plus @ nat @ M @ K )
        = ( plus_plus @ nat @ N @ K ) )
      = ( M = N ) ) ).

% nat_add_right_cancel
thf(fact_122_is__num__normalize_I1_J,axiom,
    ! [A: $tType] :
      ( ( neg_numeral @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B2 ) @ C2 )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% is_num_normalize(1)
thf(fact_123_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_add @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B2 ) @ C2 )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% ab_semigroup_add_class.add_ac(1)
thf(fact_124_add__mono__thms__linordered__semiring_I4_J,axiom,
    ! [A: $tType] :
      ( ( ordere779506340up_add @ A @ ( type @ A ) )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( I = J )
            & ( K = L ) )
         => ( ( plus_plus @ A @ I @ K )
            = ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_semiring(4)
thf(fact_125_add_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semigroup_add @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B2 ) @ C2 )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% add.assoc
thf(fact_126_add_Oleft__cancel,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ( plus_plus @ A @ A2 @ B2 )
            = ( plus_plus @ A @ A2 @ C2 ) )
          = ( B2 = C2 ) ) ) ).

% add.left_cancel
thf(fact_127_add_Oright__cancel,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type @ A ) )
     => ! [B2: A,A2: A,C2: A] :
          ( ( ( plus_plus @ A @ B2 @ A2 )
            = ( plus_plus @ A @ C2 @ A2 ) )
          = ( B2 = C2 ) ) ) ).

% add.right_cancel
thf(fact_128_add_Ocommute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_add @ A @ ( type @ A ) )
     => ( ( plus_plus @ A )
        = ( ^ [A5: A,B4: A] : ( plus_plus @ A @ B4 @ A5 ) ) ) ) ).

% add.commute
thf(fact_129_add_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_add @ A @ ( type @ A ) )
     => ! [B2: A,A2: A,C2: A] :
          ( ( plus_plus @ A @ B2 @ ( plus_plus @ A @ A2 @ C2 ) )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% add.left_commute
thf(fact_130_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ( plus_plus @ A @ A2 @ B2 )
            = ( plus_plus @ A @ A2 @ C2 ) )
         => ( B2 = C2 ) ) ) ).

% add_left_imp_eq
thf(fact_131_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( ( cancel_semigroup_add @ A @ ( type @ A ) )
     => ! [B2: A,A2: A,C2: A] :
          ( ( ( plus_plus @ A @ B2 @ A2 )
            = ( plus_plus @ A @ C2 @ A2 ) )
         => ( B2 = C2 ) ) ) ).

% add_right_imp_eq
thf(fact_132_add__eq__0__iff__both__eq__0,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A @ ( type @ A ) )
     => ! [X5: A,Y: A] :
          ( ( ( plus_plus @ A @ X5 @ Y )
            = ( zero_zero @ A ) )
          = ( ( X5
              = ( zero_zero @ A ) )
            & ( Y
              = ( zero_zero @ A ) ) ) ) ) ).

% add_eq_0_iff_both_eq_0
thf(fact_133_add_Ogroup__left__neutral,axiom,
    ! [A: $tType] :
      ( ( group_add @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% add.group_left_neutral
thf(fact_134_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_add @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% add.comm_neutral
thf(fact_135_comm__monoid__add__class_Oadd__0,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_add @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% comm_monoid_add_class.add_0
thf(fact_136_add__less__imp__less__right,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type @ A ) )
     => ! [A2: A,C2: A,B2: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ A2 @ C2 ) @ ( plus_plus @ A @ B2 @ C2 ) )
         => ( ord_less @ A @ A2 @ B2 ) ) ) ).

% add_less_imp_less_right
thf(fact_137_add__less__imp__less__left,axiom,
    ! [A: $tType] :
      ( ( ordere236663937imp_le @ A @ ( type @ A ) )
     => ! [C2: A,A2: A,B2: A] :
          ( ( ord_less @ A @ ( plus_plus @ A @ C2 @ A2 ) @ ( plus_plus @ A @ C2 @ B2 ) )
         => ( ord_less @ A @ A2 @ B2 ) ) ) ).

% add_less_imp_less_left
thf(fact_138_add__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ord_less @ A @ ( plus_plus @ A @ A2 @ C2 ) @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% add_strict_right_mono
thf(fact_139_add__strict__left__mono,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ord_less @ A @ ( plus_plus @ A @ C2 @ A2 ) @ ( plus_plus @ A @ C2 @ B2 ) ) ) ) ).

% add_strict_left_mono
thf(fact_140_add__strict__mono,axiom,
    ! [A: $tType] :
      ( ( strict2144017051up_add @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A,D: A] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ( ord_less @ A @ C2 @ D )
           => ( ord_less @ A @ ( plus_plus @ A @ A2 @ C2 ) @ ( plus_plus @ A @ B2 @ D ) ) ) ) ) ).

% add_strict_mono
thf(fact_141_add__mono__thms__linordered__field_I1_J,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A @ ( type @ A ) )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( ord_less @ A @ I @ J )
            & ( K = L ) )
         => ( ord_less @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_field(1)
thf(fact_142_add__mono__thms__linordered__field_I2_J,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A @ ( type @ A ) )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( I = J )
            & ( ord_less @ A @ K @ L ) )
         => ( ord_less @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_field(2)
thf(fact_143_add__mono__thms__linordered__field_I5_J,axiom,
    ! [A: $tType] :
      ( ( ordere223160158up_add @ A @ ( type @ A ) )
     => ! [I: A,J: A,K: A,L: A] :
          ( ( ( ord_less @ A @ I @ J )
            & ( ord_less @ A @ K @ L ) )
         => ( ord_less @ A @ ( plus_plus @ A @ I @ K ) @ ( plus_plus @ A @ J @ L ) ) ) ) ).

% add_mono_thms_linordered_field(5)
thf(fact_144_plus__nat_Oadd__0,axiom,
    ! [N: nat] :
      ( ( plus_plus @ nat @ ( zero_zero @ nat ) @ N )
      = N ) ).

% plus_nat.add_0
thf(fact_145_add__eq__self__zero,axiom,
    ! [M: nat,N: nat] :
      ( ( ( plus_plus @ nat @ M @ N )
        = M )
     => ( N
        = ( zero_zero @ nat ) ) ) ).

% add_eq_self_zero
thf(fact_146_add__lessD1,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less @ nat @ ( plus_plus @ nat @ I @ J ) @ K )
     => ( ord_less @ nat @ I @ K ) ) ).

% add_lessD1
thf(fact_147_add__less__mono,axiom,
    ! [I: nat,J: nat,K: nat,L: nat] :
      ( ( ord_less @ nat @ I @ J )
     => ( ( ord_less @ nat @ K @ L )
       => ( ord_less @ nat @ ( plus_plus @ nat @ I @ K ) @ ( plus_plus @ nat @ J @ L ) ) ) ) ).

% add_less_mono
thf(fact_148_not__add__less1,axiom,
    ! [I: nat,J: nat] :
      ~ ( ord_less @ nat @ ( plus_plus @ nat @ I @ J ) @ I ) ).

% not_add_less1
thf(fact_149_not__add__less2,axiom,
    ! [J: nat,I: nat] :
      ~ ( ord_less @ nat @ ( plus_plus @ nat @ J @ I ) @ I ) ).

% not_add_less2
thf(fact_150_add__less__mono1,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less @ nat @ I @ J )
     => ( ord_less @ nat @ ( plus_plus @ nat @ I @ K ) @ ( plus_plus @ nat @ J @ K ) ) ) ).

% add_less_mono1
thf(fact_151_trans__less__add1,axiom,
    ! [I: nat,J: nat,M: nat] :
      ( ( ord_less @ nat @ I @ J )
     => ( ord_less @ nat @ I @ ( plus_plus @ nat @ J @ M ) ) ) ).

% trans_less_add1
thf(fact_152_trans__less__add2,axiom,
    ! [I: nat,J: nat,M: nat] :
      ( ( ord_less @ nat @ I @ J )
     => ( ord_less @ nat @ I @ ( plus_plus @ nat @ M @ J ) ) ) ).

% trans_less_add2
thf(fact_153_less__add__eq__less,axiom,
    ! [K: nat,L: nat,M: nat,N: nat] :
      ( ( ord_less @ nat @ K @ L )
     => ( ( ( plus_plus @ nat @ M @ L )
          = ( plus_plus @ nat @ K @ N ) )
       => ( ord_less @ nat @ M @ N ) ) ) ).

% less_add_eq_less
thf(fact_154_cost_Osimps_I2_J,axiom,
    ! [A: $tType,W: nat,T_1: huffma16452318e_tree @ A,T_2: huffma16452318e_tree @ A] :
      ( ( huffma636208924e_cost @ A @ ( huffma1759677307erNode @ A @ W @ T_1 @ T_2 ) )
      = ( plus_plus @ nat @ ( plus_plus @ nat @ ( plus_plus @ nat @ ( huffma691733767weight @ A @ T_1 ) @ ( huffma636208924e_cost @ A @ T_1 ) ) @ ( huffma691733767weight @ A @ T_2 ) ) @ ( huffma636208924e_cost @ A @ T_2 ) ) ) ).

% cost.simps(2)
thf(fact_155_of__nat__less__0__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ! [M: nat] :
          ~ ( ord_less @ A @ ( semiring_1_of_nat @ A @ M ) @ ( zero_zero @ A ) ) ) ).

% of_nat_less_0_iff
thf(fact_156_of__nat__less__imp__less,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ! [M: nat,N: nat] :
          ( ( ord_less @ A @ ( semiring_1_of_nat @ A @ M ) @ ( semiring_1_of_nat @ A @ N ) )
         => ( ord_less @ nat @ M @ N ) ) ) ).

% of_nat_less_imp_less
thf(fact_157_less__imp__of__nat__less,axiom,
    ! [A: $tType] :
      ( ( linordered_semidom @ A @ ( type @ A ) )
     => ! [M: nat,N: nat] :
          ( ( ord_less @ nat @ M @ N )
         => ( ord_less @ A @ ( semiring_1_of_nat @ A @ M ) @ ( semiring_1_of_nat @ A @ N ) ) ) ) ).

% less_imp_of_nat_less
thf(fact_158_add__neg__neg,axiom,
    ! [A: $tType] :
      ( ( ordere216010020id_add @ A @ ( type @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
         => ( ( ord_less @ A @ B2 @ ( zero_zero @ A ) )
           => ( ord_less @ A @ ( plus_plus @ A @ A2 @ B2 ) @ ( zero_zero @ A ) ) ) ) ) ).

% add_neg_neg
thf(fact_159_add__pos__pos,axiom,
    ! [A: $tType] :
      ( ( ordere216010020id_add @ A @ ( type @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ B2 )
           => ( ord_less @ A @ ( zero_zero @ A ) @ ( plus_plus @ A @ A2 @ B2 ) ) ) ) ) ).

% add_pos_pos
thf(fact_160_pos__add__strict,axiom,
    ! [A: $tType] :
      ( ( strict797366125id_add @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less @ A @ B2 @ C2 )
           => ( ord_less @ A @ B2 @ ( plus_plus @ A @ A2 @ C2 ) ) ) ) ) ).

% pos_add_strict
thf(fact_161_less__imp__add__positive,axiom,
    ! [I: nat,J: nat] :
      ( ( ord_less @ nat @ I @ J )
     => ? [K2: nat] :
          ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K2 )
          & ( ( plus_plus @ nat @ I @ K2 )
            = J ) ) ) ).

% less_imp_add_positive
thf(fact_162_freq_Osimps_I2_J,axiom,
    ! [A: $tType,W: nat,T_1: huffma16452318e_tree @ A,T_2: huffma16452318e_tree @ A] :
      ( ( huffma854352999e_freq @ A @ ( huffma1759677307erNode @ A @ W @ T_1 @ T_2 ) )
      = ( ^ [B4: A] : ( plus_plus @ nat @ ( huffma854352999e_freq @ A @ T_1 @ B4 ) @ ( huffma854352999e_freq @ A @ T_2 @ B4 ) ) ) ) ).

% freq.simps(2)
thf(fact_163_weight_Osimps_I2_J,axiom,
    ! [A: $tType,W: nat,T_1: huffma16452318e_tree @ A,T_2: huffma16452318e_tree @ A] :
      ( ( huffma691733767weight @ A @ ( huffma1759677307erNode @ A @ W @ T_1 @ T_2 ) )
      = ( plus_plus @ nat @ ( huffma691733767weight @ A @ T_1 ) @ ( huffma691733767weight @ A @ T_2 ) ) ) ).

% weight.simps(2)
thf(fact_164_cost__swapLeaves,axiom,
    ! [A: $tType,T: huffma16452318e_tree @ A,A2: A,B2: A,W_a: nat,W_b: nat] :
      ( ( huffma1050891809istent @ A @ T )
     => ( ( A2 != B2 )
       => ( ( ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
           => ( ( ( member @ A @ B2 @ ( huffma505251170phabet @ A @ T ) )
               => ( ( plus_plus @ nat @ ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B2 ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ A @ T @ A2 ) @ ( huffma223349076_depth @ A @ T @ A2 ) ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ A @ T @ B2 ) @ ( huffma223349076_depth @ A @ T @ B2 ) ) )
                  = ( plus_plus @ nat @ ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ T ) @ ( times_times @ nat @ W_a @ ( huffma223349076_depth @ A @ T @ B2 ) ) ) @ ( times_times @ nat @ W_b @ ( huffma223349076_depth @ A @ T @ A2 ) ) ) ) )
              & ( ~ ( member @ A @ B2 @ ( huffma505251170phabet @ A @ T ) )
               => ( ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B2 ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ A @ T @ A2 ) @ ( huffma223349076_depth @ A @ T @ A2 ) ) )
                  = ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ T ) @ ( times_times @ nat @ W_b @ ( huffma223349076_depth @ A @ T @ A2 ) ) ) ) ) ) )
          & ( ~ ( member @ A @ A2 @ ( huffma505251170phabet @ A @ T ) )
           => ( ( ( member @ A @ B2 @ ( huffma505251170phabet @ A @ T ) )
               => ( ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B2 ) ) @ ( times_times @ nat @ ( huffma854352999e_freq @ A @ T @ B2 ) @ ( huffma223349076_depth @ A @ T @ B2 ) ) )
                  = ( plus_plus @ nat @ ( huffma636208924e_cost @ A @ T ) @ ( times_times @ nat @ W_a @ ( huffma223349076_depth @ A @ T @ B2 ) ) ) ) )
              & ( ~ ( member @ A @ B2 @ ( huffma505251170phabet @ A @ T ) )
               => ( ( huffma636208924e_cost @ A @ ( huffma2094459102Leaves @ A @ T @ W_a @ A2 @ W_b @ B2 ) )
                  = ( huffma636208924e_cost @ A @ T ) ) ) ) ) ) ) ) ).

% cost_swapLeaves
thf(fact_165_uniteTrees__def,axiom,
    ! [A: $tType] :
      ( ( huffma453905539eTrees @ A )
      = ( ^ [T_13: huffma16452318e_tree @ A,T_23: huffma16452318e_tree @ A] : ( huffma1759677307erNode @ A @ ( plus_plus @ nat @ ( huffma787811817Weight @ A @ T_13 ) @ ( huffma787811817Weight @ A @ T_23 ) ) @ T_13 @ T_23 ) ) ) ).

% uniteTrees_def
thf(fact_166_zero__less__imp__eq__int,axiom,
    ! [K: int] :
      ( ( ord_less @ int @ ( zero_zero @ int ) @ K )
     => ? [N2: nat] :
          ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N2 )
          & ( K
            = ( semiring_1_of_nat @ int @ N2 ) ) ) ) ).

% zero_less_imp_eq_int
thf(fact_167_freq__uniteTrees,axiom,
    ! [A: $tType,T_1: huffma16452318e_tree @ A,T_2: huffma16452318e_tree @ A] :
      ( ( huffma854352999e_freq @ A @ ( huffma453905539eTrees @ A @ T_1 @ T_2 ) )
      = ( ^ [A5: A] : ( plus_plus @ nat @ ( huffma854352999e_freq @ A @ T_1 @ A5 ) @ ( huffma854352999e_freq @ A @ T_2 @ A5 ) ) ) ) ).

% freq_uniteTrees
thf(fact_168_semiring__normalization__rules_I6_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ A2 @ ( zero_zero @ A ) )
          = A2 ) ) ).

% semiring_normalization_rules(6)
thf(fact_169_mult__cancel2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ( times_times @ nat @ M @ K )
        = ( times_times @ nat @ N @ K ) )
      = ( ( M = N )
        | ( K
          = ( zero_zero @ nat ) ) ) ) ).

% mult_cancel2
thf(fact_170_mult__cancel1,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ( times_times @ nat @ K @ M )
        = ( times_times @ nat @ K @ N ) )
      = ( ( M = N )
        | ( K
          = ( zero_zero @ nat ) ) ) ) ).

% mult_cancel1
thf(fact_171_mult__0__right,axiom,
    ! [M: nat] :
      ( ( times_times @ nat @ M @ ( zero_zero @ nat ) )
      = ( zero_zero @ nat ) ) ).

% mult_0_right
thf(fact_172_mult__is__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ( times_times @ nat @ M @ N )
        = ( zero_zero @ nat ) )
      = ( ( M
          = ( zero_zero @ nat ) )
        | ( N
          = ( zero_zero @ nat ) ) ) ) ).

% mult_is_0
thf(fact_173_nat__0__less__mult__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( times_times @ nat @ M @ N ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ M )
        & ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ) ).

% nat_0_less_mult_iff
thf(fact_174_mult__less__cancel2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less @ nat @ ( times_times @ nat @ M @ K ) @ ( times_times @ nat @ N @ K ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K )
        & ( ord_less @ nat @ M @ N ) ) ) ).

% mult_less_cancel2
thf(fact_175_of__nat__mult,axiom,
    ! [A: $tType] :
      ( ( semiring_1 @ A @ ( type @ A ) )
     => ! [M: nat,N: nat] :
          ( ( semiring_1_of_nat @ A @ ( times_times @ nat @ M @ N ) )
          = ( times_times @ A @ ( semiring_1_of_nat @ A @ M ) @ ( semiring_1_of_nat @ A @ N ) ) ) ) ).

% of_nat_mult
thf(fact_176_crossproduct__noteq,axiom,
    ! [A: $tType] :
      ( ( semiri456707255roduct @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A,D: A] :
          ( ( ( A2 != B2 )
            & ( C2 != D ) )
          = ( ( plus_plus @ A @ ( times_times @ A @ A2 @ C2 ) @ ( times_times @ A @ B2 @ D ) )
           != ( plus_plus @ A @ ( times_times @ A @ A2 @ D ) @ ( times_times @ A @ B2 @ C2 ) ) ) ) ) ).

% crossproduct_noteq
thf(fact_177_crossproduct__eq,axiom,
    ! [A: $tType] :
      ( ( semiri456707255roduct @ A @ ( type @ A ) )
     => ! [W: A,Y: A,X5: A,Z: A] :
          ( ( ( plus_plus @ A @ ( times_times @ A @ W @ Y ) @ ( times_times @ A @ X5 @ Z ) )
            = ( plus_plus @ A @ ( times_times @ A @ W @ Z ) @ ( times_times @ A @ X5 @ Y ) ) )
          = ( ( W = X5 )
            | ( Y = Z ) ) ) ) ).

% crossproduct_eq
thf(fact_178_zadd__int__left,axiom,
    ! [M: nat,N: nat,Z: int] :
      ( ( plus_plus @ int @ ( semiring_1_of_nat @ int @ M ) @ ( plus_plus @ int @ ( semiring_1_of_nat @ int @ N ) @ Z ) )
      = ( plus_plus @ int @ ( semiring_1_of_nat @ int @ ( plus_plus @ nat @ M @ N ) ) @ Z ) ) ).

% zadd_int_left
thf(fact_179_int__int__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ( semiring_1_of_nat @ int @ M )
        = ( semiring_1_of_nat @ int @ N ) )
      = ( M = N ) ) ).

% int_int_eq
thf(fact_180_semiring__normalization__rules_I1_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A,M: A,B2: A] :
          ( ( plus_plus @ A @ ( times_times @ A @ A2 @ M ) @ ( times_times @ A @ B2 @ M ) )
          = ( times_times @ A @ ( plus_plus @ A @ A2 @ B2 ) @ M ) ) ) ).

% semiring_normalization_rules(1)
thf(fact_181_semiring__normalization__rules_I8_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( times_times @ A @ ( plus_plus @ A @ A2 @ B2 ) @ C2 )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ C2 ) @ ( times_times @ A @ B2 @ C2 ) ) ) ) ).

% semiring_normalization_rules(8)
thf(fact_182_semiring__normalization__rules_I34_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [X5: A,Y: A,Z: A] :
          ( ( times_times @ A @ X5 @ ( plus_plus @ A @ Y @ Z ) )
          = ( plus_plus @ A @ ( times_times @ A @ X5 @ Y ) @ ( times_times @ A @ X5 @ Z ) ) ) ) ).

% semiring_normalization_rules(34)
thf(fact_183_zero__integer_Orsp,axiom,
    ( ( zero_zero @ int )
    = ( zero_zero @ int ) ) ).

% zero_integer.rsp
thf(fact_184_plus__int__code_I1_J,axiom,
    ! [K: int] :
      ( ( plus_plus @ int @ K @ ( zero_zero @ int ) )
      = K ) ).

% plus_int_code(1)
thf(fact_185_plus__int__code_I2_J,axiom,
    ! [L: int] :
      ( ( plus_plus @ int @ ( zero_zero @ int ) @ L )
      = L ) ).

% plus_int_code(2)
thf(fact_186_mult_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A @ ( type @ A ) )
     => ! [B2: A,A2: A,C2: A] :
          ( ( times_times @ A @ B2 @ ( times_times @ A @ A2 @ C2 ) )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B2 @ C2 ) ) ) ) ).

% mult.left_commute
thf(fact_187_mult_Ocommute,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A @ ( type @ A ) )
     => ( ( times_times @ A )
        = ( ^ [A5: A,B4: A] : ( times_times @ A @ B4 @ A5 ) ) ) ) ).

% mult.commute
thf(fact_188_mult_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semigroup_mult @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( times_times @ A @ ( times_times @ A @ A2 @ B2 ) @ C2 )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B2 @ C2 ) ) ) ) ).

% mult.assoc
thf(fact_189_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ( ab_semigroup_mult @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( times_times @ A @ ( times_times @ A @ A2 @ B2 ) @ C2 )
          = ( times_times @ A @ A2 @ ( times_times @ A @ B2 @ C2 ) ) ) ) ).

% ab_semigroup_mult_class.mult_ac(1)
thf(fact_190_semiring__normalization__rules_I9_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ ( zero_zero @ A ) @ A2 )
          = ( zero_zero @ A ) ) ) ).

% semiring_normalization_rules(9)
thf(fact_191_semiring__normalization__rules_I10_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ A2 @ ( zero_zero @ A ) )
          = ( zero_zero @ A ) ) ) ).

% semiring_normalization_rules(10)
thf(fact_192_semiring__normalization__rules_I19_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [Lx: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ Lx @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ Rx @ ( times_times @ A @ Lx @ Ry ) ) ) ) ).

% semiring_normalization_rules(19)
thf(fact_193_semiring__normalization__rules_I18_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [Lx: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ Lx @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ ( times_times @ A @ Lx @ Rx ) @ Ry ) ) ) ).

% semiring_normalization_rules(18)
thf(fact_194_semiring__normalization__rules_I17_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [Lx: A,Ly: A,Rx: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ Rx )
          = ( times_times @ A @ Lx @ ( times_times @ A @ Ly @ Rx ) ) ) ) ).

% semiring_normalization_rules(17)
thf(fact_195_semiring__normalization__rules_I16_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [Lx: A,Ly: A,Rx: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ Rx )
          = ( times_times @ A @ ( times_times @ A @ Lx @ Rx ) @ Ly ) ) ) ).

% semiring_normalization_rules(16)
thf(fact_196_semiring__normalization__rules_I15_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [Lx: A,Ly: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ Rx @ ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ Ry ) ) ) ) ).

% semiring_normalization_rules(15)
thf(fact_197_semiring__normalization__rules_I14_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [Lx: A,Ly: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ Lx @ ( times_times @ A @ Ly @ ( times_times @ A @ Rx @ Ry ) ) ) ) ) ).

% semiring_normalization_rules(14)
thf(fact_198_semiring__normalization__rules_I13_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [Lx: A,Ly: A,Rx: A,Ry: A] :
          ( ( times_times @ A @ ( times_times @ A @ Lx @ Ly ) @ ( times_times @ A @ Rx @ Ry ) )
          = ( times_times @ A @ ( times_times @ A @ Lx @ Rx ) @ ( times_times @ A @ Ly @ Ry ) ) ) ) ).

% semiring_normalization_rules(13)
thf(fact_199_semiring__normalization__rules_I7_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ( ( times_times @ A )
        = ( ^ [A5: A,B4: A] : ( times_times @ A @ B4 @ A5 ) ) ) ) ).

% semiring_normalization_rules(7)
thf(fact_200_less__int__code_I1_J,axiom,
    ~ ( ord_less @ int @ ( zero_zero @ int ) @ ( zero_zero @ int ) ) ).

% less_int_code(1)
thf(fact_201_mult__0,axiom,
    ! [N: nat] :
      ( ( times_times @ nat @ ( zero_zero @ nat ) @ N )
      = ( zero_zero @ nat ) ) ).

% mult_0
thf(fact_202_add__mult__distrib2,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( times_times @ nat @ K @ ( plus_plus @ nat @ M @ N ) )
      = ( plus_plus @ nat @ ( times_times @ nat @ K @ M ) @ ( times_times @ nat @ K @ N ) ) ) ).

% add_mult_distrib2
thf(fact_203_add__mult__distrib,axiom,
    ! [M: nat,N: nat,K: nat] :
      ( ( times_times @ nat @ ( plus_plus @ nat @ M @ N ) @ K )
      = ( plus_plus @ nat @ ( times_times @ nat @ M @ K ) @ ( times_times @ nat @ N @ K ) ) ) ).

% add_mult_distrib
thf(fact_204_mult__of__nat__commute,axiom,
    ! [A: $tType] :
      ( ( semiring_1 @ A @ ( type @ A ) )
     => ! [X5: nat,Y: A] :
          ( ( times_times @ A @ ( semiring_1_of_nat @ A @ X5 ) @ Y )
          = ( times_times @ A @ Y @ ( semiring_1_of_nat @ A @ X5 ) ) ) ) ).

% mult_of_nat_commute
thf(fact_205_add__scale__eq__noteq,axiom,
    ! [A: $tType] :
      ( ( semiri456707255roduct @ A @ ( type @ A ) )
     => ! [R: A,A2: A,B2: A,C2: A,D: A] :
          ( ( R
           != ( zero_zero @ A ) )
         => ( ( ( A2 = B2 )
              & ( C2 != D ) )
           => ( ( plus_plus @ A @ A2 @ ( times_times @ A @ R @ C2 ) )
             != ( plus_plus @ A @ B2 @ ( times_times @ A @ R @ D ) ) ) ) ) ) ).

% add_scale_eq_noteq
thf(fact_206_mult__less__mono2,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less @ nat @ I @ J )
     => ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K )
       => ( ord_less @ nat @ ( times_times @ nat @ K @ I ) @ ( times_times @ nat @ K @ J ) ) ) ) ).

% mult_less_mono2
thf(fact_207_mult__less__mono1,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less @ nat @ I @ J )
     => ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K )
       => ( ord_less @ nat @ ( times_times @ nat @ I @ K ) @ ( times_times @ nat @ J @ K ) ) ) ) ).

% mult_less_mono1
thf(fact_208_semiring__normalization__rules_I25_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A,C2: A,D: A] :
          ( ( plus_plus @ A @ A2 @ ( plus_plus @ A @ C2 @ D ) )
          = ( plus_plus @ A @ ( plus_plus @ A @ A2 @ C2 ) @ D ) ) ) ).

% semiring_normalization_rules(25)
thf(fact_209_semiring__normalization__rules_I24_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ( ( plus_plus @ A )
        = ( ^ [A5: A,C4: A] : ( plus_plus @ A @ C4 @ A5 ) ) ) ) ).

% semiring_normalization_rules(24)
thf(fact_210_semiring__normalization__rules_I23_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B2 ) @ C2 )
          = ( plus_plus @ A @ ( plus_plus @ A @ A2 @ C2 ) @ B2 ) ) ) ).

% semiring_normalization_rules(23)
thf(fact_211_semiring__normalization__rules_I22_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A,C2: A,D: A] :
          ( ( plus_plus @ A @ A2 @ ( plus_plus @ A @ C2 @ D ) )
          = ( plus_plus @ A @ C2 @ ( plus_plus @ A @ A2 @ D ) ) ) ) ).

% semiring_normalization_rules(22)
thf(fact_212_semiring__normalization__rules_I21_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B2 ) @ C2 )
          = ( plus_plus @ A @ A2 @ ( plus_plus @ A @ B2 @ C2 ) ) ) ) ).

% semiring_normalization_rules(21)
thf(fact_213_semiring__normalization__rules_I20_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A,D: A] :
          ( ( plus_plus @ A @ ( plus_plus @ A @ A2 @ B2 ) @ ( plus_plus @ A @ C2 @ D ) )
          = ( plus_plus @ A @ ( plus_plus @ A @ A2 @ C2 ) @ ( plus_plus @ A @ B2 @ D ) ) ) ) ).

% semiring_normalization_rules(20)
thf(fact_214_add__0__iff,axiom,
    ! [A: $tType] :
      ( ( semiri456707255roduct @ A @ ( type @ A ) )
     => ! [B2: A,A2: A] :
          ( ( B2
            = ( plus_plus @ A @ B2 @ A2 ) )
          = ( A2
            = ( zero_zero @ A ) ) ) ) ).

% add_0_iff
thf(fact_215_semiring__normalization__rules_I5_J,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( plus_plus @ A @ ( zero_zero @ A ) @ A2 )
          = A2 ) ) ).

% semiring_normalization_rules(5)
thf(fact_216_nat__mult__less__cancel__disj,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less @ nat @ ( times_times @ nat @ K @ M ) @ ( times_times @ nat @ K @ N ) )
      = ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K )
        & ( ord_less @ nat @ M @ N ) ) ) ).

% nat_mult_less_cancel_disj
thf(fact_217_mult__cancel__right,axiom,
    ! [A: $tType] :
      ( ( semiri1923998003cancel @ A @ ( type @ A ) )
     => ! [A2: A,C2: A,B2: A] :
          ( ( ( times_times @ A @ A2 @ C2 )
            = ( times_times @ A @ B2 @ C2 ) )
          = ( ( C2
              = ( zero_zero @ A ) )
            | ( A2 = B2 ) ) ) ) ).

% mult_cancel_right
thf(fact_218_mult__cancel__left,axiom,
    ! [A: $tType] :
      ( ( semiri1923998003cancel @ A @ ( type @ A ) )
     => ! [C2: A,A2: A,B2: A] :
          ( ( ( times_times @ A @ C2 @ A2 )
            = ( times_times @ A @ C2 @ B2 ) )
          = ( ( C2
              = ( zero_zero @ A ) )
            | ( A2 = B2 ) ) ) ) ).

% mult_cancel_left
thf(fact_219_mult__zero__left,axiom,
    ! [A: $tType] :
      ( ( mult_zero @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ ( zero_zero @ A ) @ A2 )
          = ( zero_zero @ A ) ) ) ).

% mult_zero_left
thf(fact_220_mult__zero__right,axiom,
    ! [A: $tType] :
      ( ( mult_zero @ A @ ( type @ A ) )
     => ! [A2: A] :
          ( ( times_times @ A @ A2 @ ( zero_zero @ A ) )
          = ( zero_zero @ A ) ) ) ).

% mult_zero_right
thf(fact_221_mult__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( semiri1193490041visors @ A @ ( type @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ( times_times @ A @ A2 @ B2 )
            = ( zero_zero @ A ) )
          = ( ( A2
              = ( zero_zero @ A ) )
            | ( B2
              = ( zero_zero @ A ) ) ) ) ) ).

% mult_eq_0_iff
thf(fact_222_int__distrib_I1_J,axiom,
    ! [Z1: int,Z2: int,W: int] :
      ( ( times_times @ int @ ( plus_plus @ int @ Z1 @ Z2 ) @ W )
      = ( plus_plus @ int @ ( times_times @ int @ Z1 @ W ) @ ( times_times @ int @ Z2 @ W ) ) ) ).

% int_distrib(1)
thf(fact_223_int__distrib_I2_J,axiom,
    ! [W: int,Z1: int,Z2: int] :
      ( ( times_times @ int @ W @ ( plus_plus @ int @ Z1 @ Z2 ) )
      = ( plus_plus @ int @ ( times_times @ int @ W @ Z1 ) @ ( times_times @ int @ W @ Z2 ) ) ) ).

% int_distrib(2)
thf(fact_224_times__int__code_I2_J,axiom,
    ! [L: int] :
      ( ( times_times @ int @ ( zero_zero @ int ) @ L )
      = ( zero_zero @ int ) ) ).

% times_int_code(2)
thf(fact_225_times__int__code_I1_J,axiom,
    ! [K: int] :
      ( ( times_times @ int @ K @ ( zero_zero @ int ) )
      = ( zero_zero @ int ) ) ).

% times_int_code(1)
thf(fact_226_zmult__zless__mono2,axiom,
    ! [I: int,J: int,K: int] :
      ( ( ord_less @ int @ I @ J )
     => ( ( ord_less @ int @ ( zero_zero @ int ) @ K )
       => ( ord_less @ int @ ( times_times @ int @ K @ I ) @ ( times_times @ int @ K @ J ) ) ) ) ).

% zmult_zless_mono2
thf(fact_227_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A @ ( type @ A ) )
     => ! [X5: A,Y: A] :
          ( ( X5 != Y )
         => ( ~ ( ord_less @ A @ X5 @ Y )
           => ( ord_less @ A @ Y @ X5 ) ) ) ) ).

% linorder_neqE_linordered_idom
thf(fact_228_zmult__zless__mono2__lemma,axiom,
    ! [I: int,J: int,K: nat] :
      ( ( ord_less @ int @ I @ J )
     => ( ( ord_less @ nat @ ( zero_zero @ nat ) @ K )
       => ( ord_less @ int @ ( times_times @ int @ ( semiring_1_of_nat @ int @ K ) @ I ) @ ( times_times @ int @ ( semiring_1_of_nat @ int @ K ) @ J ) ) ) ) ).

% zmult_zless_mono2_lemma
thf(fact_229_mult__not__zero,axiom,
    ! [A: $tType] :
      ( ( mult_zero @ A @ ( type @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ( times_times @ A @ A2 @ B2 )
           != ( zero_zero @ A ) )
         => ( ( A2
             != ( zero_zero @ A ) )
            & ( B2
             != ( zero_zero @ A ) ) ) ) ) ).

% mult_not_zero
thf(fact_230_divisors__zero,axiom,
    ! [A: $tType] :
      ( ( semiri1193490041visors @ A @ ( type @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ( times_times @ A @ A2 @ B2 )
            = ( zero_zero @ A ) )
         => ( ( A2
              = ( zero_zero @ A ) )
            | ( B2
              = ( zero_zero @ A ) ) ) ) ) ).

% divisors_zero
thf(fact_231_no__zero__divisors,axiom,
    ! [A: $tType] :
      ( ( semiri1193490041visors @ A @ ( type @ A ) )
     => ! [A2: A,B2: A] :
          ( ( A2
           != ( zero_zero @ A ) )
         => ( ( B2
             != ( zero_zero @ A ) )
           => ( ( times_times @ A @ A2 @ B2 )
             != ( zero_zero @ A ) ) ) ) ) ).

% no_zero_divisors
thf(fact_232_mult__left__cancel,axiom,
    ! [A: $tType] :
      ( ( semiri1923998003cancel @ A @ ( type @ A ) )
     => ! [C2: A,A2: A,B2: A] :
          ( ( C2
           != ( zero_zero @ A ) )
         => ( ( ( times_times @ A @ C2 @ A2 )
              = ( times_times @ A @ C2 @ B2 ) )
            = ( A2 = B2 ) ) ) ) ).

% mult_left_cancel
thf(fact_233_mult__right__cancel,axiom,
    ! [A: $tType] :
      ( ( semiri1923998003cancel @ A @ ( type @ A ) )
     => ! [C2: A,A2: A,B2: A] :
          ( ( C2
           != ( zero_zero @ A ) )
         => ( ( ( times_times @ A @ A2 @ C2 )
              = ( times_times @ A @ B2 @ C2 ) )
            = ( A2 = B2 ) ) ) ) ).

% mult_right_cancel
thf(fact_234_ring__class_Oring__distribs_I2_J,axiom,
    ! [A: $tType] :
      ( ( ring @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( times_times @ A @ ( plus_plus @ A @ A2 @ B2 ) @ C2 )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ C2 ) @ ( times_times @ A @ B2 @ C2 ) ) ) ) ).

% ring_class.ring_distribs(2)
thf(fact_235_ring__class_Oring__distribs_I1_J,axiom,
    ! [A: $tType] :
      ( ( ring @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( times_times @ A @ A2 @ ( plus_plus @ A @ B2 @ C2 ) )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ B2 ) @ ( times_times @ A @ A2 @ C2 ) ) ) ) ).

% ring_class.ring_distribs(1)
thf(fact_236_comm__semiring__class_Odistrib,axiom,
    ! [A: $tType] :
      ( ( comm_semiring @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( times_times @ A @ ( plus_plus @ A @ A2 @ B2 ) @ C2 )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ C2 ) @ ( times_times @ A @ B2 @ C2 ) ) ) ) ).

% comm_semiring_class.distrib
thf(fact_237_distrib__left,axiom,
    ! [A: $tType] :
      ( ( semiring @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( times_times @ A @ A2 @ ( plus_plus @ A @ B2 @ C2 ) )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ B2 ) @ ( times_times @ A @ A2 @ C2 ) ) ) ) ).

% distrib_left
thf(fact_238_distrib__right,axiom,
    ! [A: $tType] :
      ( ( semiring @ A @ ( type @ A ) )
     => ! [A2: A,B2: A,C2: A] :
          ( ( times_times @ A @ ( plus_plus @ A @ A2 @ B2 ) @ C2 )
          = ( plus_plus @ A @ ( times_times @ A @ A2 @ C2 ) @ ( times_times @ A @ B2 @ C2 ) ) ) ) ).

% distrib_right
thf(fact_239_combine__common__factor,axiom,
    ! [A: $tType] :
      ( ( semiring @ A @ ( type @ A ) )
     => ! [A2: A,E: A,B2: A,C2: A] :
          ( ( plus_plus @ A @ ( times_times @ A @ A2 @ E ) @ ( plus_plus @ A @ ( times_times @ A @ B2 @ E ) @ C2 ) )
          = ( plus_plus @ A @ ( times_times @ A @ ( plus_plus @ A @ A2 @ B2 ) @ E ) @ C2 ) ) ) ).

% combine_common_factor
thf(fact_240_nat__mult__eq__cancel__disj,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ( times_times @ nat @ K @ M )
        = ( times_times @ nat @ K @ N ) )
      = ( ( K
          = ( zero_zero @ nat ) )
        | ( M = N ) ) ) ).

% nat_mult_eq_cancel_disj
thf(fact_241_left__add__mult__distrib,axiom,
    ! [I: nat,U: nat,J: nat,K: nat] :
      ( ( plus_plus @ nat @ ( times_times @ nat @ I @ U ) @ ( plus_plus @ nat @ ( times_times @ nat @ J @ U ) @ K ) )
      = ( plus_plus @ nat @ ( times_times @ nat @ ( plus_plus @ nat @ I @ J ) @ U ) @ K ) ) ).

% left_add_mult_distrib
thf(fact_242_mult__neg__neg,axiom,
    ! [A: $tType] :
      ( ( linord581940658strict @ A @ ( type @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
         => ( ( ord_less @ A @ B2 @ ( zero_zero @ A ) )
           => ( ord_less @ A @ ( zero_zero @ A ) @ ( times_times @ A @ A2 @ B2 ) ) ) ) ) ).

% mult_neg_neg
thf(fact_243_not__square__less__zero,axiom,
    ! [A: $tType] :
      ( ( linordered_ring @ A @ ( type @ A ) )
     => ! [A2: A] :
          ~ ( ord_less @ A @ ( times_times @ A @ A2 @ A2 ) @ ( zero_zero @ A ) ) ) ).

% not_square_less_zero
thf(fact_244_mult__less__0__iff,axiom,
    ! [A: $tType] :
      ( ( linord581940658strict @ A @ ( type @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ ( times_times @ A @ A2 @ B2 ) @ ( zero_zero @ A ) )
          = ( ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less @ A @ B2 @ ( zero_zero @ A ) ) )
            | ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less @ A @ ( zero_zero @ A ) @ B2 ) ) ) ) ) ).

% mult_less_0_iff
thf(fact_245_mult__neg__pos,axiom,
    ! [A: $tType] :
      ( ( linord20386208strict @ A @ ( type @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ B2 )
           => ( ord_less @ A @ ( times_times @ A @ A2 @ B2 ) @ ( zero_zero @ A ) ) ) ) ) ).

% mult_neg_pos
thf(fact_246_mult__pos__neg,axiom,
    ! [A: $tType] :
      ( ( linord20386208strict @ A @ ( type @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less @ A @ B2 @ ( zero_zero @ A ) )
           => ( ord_less @ A @ ( times_times @ A @ A2 @ B2 ) @ ( zero_zero @ A ) ) ) ) ) ).

% mult_pos_neg
thf(fact_247_mult__pos__pos,axiom,
    ! [A: $tType] :
      ( ( linord20386208strict @ A @ ( type @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ B2 )
           => ( ord_less @ A @ ( zero_zero @ A ) @ ( times_times @ A @ A2 @ B2 ) ) ) ) ) ).

% mult_pos_pos
thf(fact_248_mult__pos__neg2,axiom,
    ! [A: $tType] :
      ( ( linord20386208strict @ A @ ( type @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
         => ( ( ord_less @ A @ B2 @ ( zero_zero @ A ) )
           => ( ord_less @ A @ ( times_times @ A @ B2 @ A2 ) @ ( zero_zero @ A ) ) ) ) ) ).

% mult_pos_neg2
thf(fact_249_zero__less__mult__iff,axiom,
    ! [A: $tType] :
      ( ( linord581940658strict @ A @ ( type @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( times_times @ A @ A2 @ B2 ) )
          = ( ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
              & ( ord_less @ A @ ( zero_zero @ A ) @ B2 ) )
            | ( ( ord_less @ A @ A2 @ ( zero_zero @ A ) )
              & ( ord_less @ A @ B2 @ ( zero_zero @ A ) ) ) ) ) ) ).

% zero_less_mult_iff
thf(fact_250_zero__less__mult__pos,axiom,
    ! [A: $tType] :
      ( ( linord20386208strict @ A @ ( type @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( times_times @ A @ A2 @ B2 ) )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
           => ( ord_less @ A @ ( zero_zero @ A ) @ B2 ) ) ) ) ).

% zero_less_mult_pos
thf(fact_251_zero__less__mult__pos2,axiom,
    ! [A: $tType] :
      ( ( linord20386208strict @ A @ ( type @ A ) )
     => ! [B2: A,A2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( times_times @ A @ B2 @ A2 ) )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ A2 )
           => ( ord_less @ A @ ( zero_zero @ A ) @ B2 ) ) ) ) ).

% zero_less_mult_pos2
thf(fact_252_mult__less__cancel__left__neg,axiom,
    ! [A: $tType] :
      ( ( linord581940658strict @ A @ ( type @ A ) )
     => ! [C2: A,A2: A,B2: A] :
          ( ( ord_less @ A @ C2 @ ( zero_zero @ A ) )
         => ( ( ord_less @ A @ ( times_times @ A @ C2 @ A2 ) @ ( times_times @ A @ C2 @ B2 ) )
            = ( ord_less @ A @ B2 @ A2 ) ) ) ) ).

% mult_less_cancel_left_neg
thf(fact_253_mult__less__cancel__left__pos,axiom,
    ! [A: $tType] :
      ( ( linord581940658strict @ A @ ( type @ A ) )
     => ! [C2: A,A2: A,B2: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ C2 )
         => ( ( ord_less @ A @ ( times_times @ A @ C2 @ A2 ) @ ( times_times @ A @ C2 @ B2 ) )
            = ( ord_less @ A @ A2 @ B2 ) ) ) ) ).

% mult_less_cancel_left_pos

%----Type constructors (62)
thf(tcon_Int_Oint___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Oordered__ab__semigroup__monoid__add__imp__le,axiom,
    ordere516151231imp_le @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Osemiring__no__zero__divisors__cancel,axiom,
    semiri1923998003cancel @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Ostrict__ordered__ab__semigroup__add,axiom,
    strict2144017051up_add @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Ostrict__ordered__comm__monoid__add,axiom,
    strict797366125id_add @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Olinordered__semiring__strict,axiom,
    linord20386208strict @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Osemiring__no__zero__divisors,axiom,
    semiri1193490041visors @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Oordered__ab__semigroup__add,axiom,
    ordere779506340up_add @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Oordered__comm__monoid__add,axiom,
    ordere216010020id_add @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Ocancel__comm__monoid__add,axiom,
    cancel1352612707id_add @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Olinordered__ring__strict,axiom,
    linord581940658strict @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Olinordered__ring,axiom,
    linordered_ring @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1 @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Osemigroup__mult,axiom,
    semigroup_mult @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Osemigroup__add,axiom,
    semigroup_add @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Ocomm__semiring,axiom,
    comm_semiring @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Nat_Osemiring__char__0,axiom,
    semiring_char_0 @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Omonoid__add,axiom,
    monoid_add @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1 @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Ogroup__add,axiom,
    group_add @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Omult__zero,axiom,
    mult_zero @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Num_Oneg__numeral,axiom,
    neg_numeral @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Osemiring,axiom,
    semiring @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Groups_Ozero,axiom,
    zero @ int @ ( type @ int ) ).

thf(tcon_Int_Oint___Rings_Oring,axiom,
    ring @ int @ ( type @ int ) ).

thf(tcon_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct_1,axiom,
    semiri456707255roduct @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__ab__semigroup__monoid__add__imp__le_2,axiom,
    ordere516151231imp_le @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Osemiring__no__zero__divisors__cancel_3,axiom,
    semiri1923998003cancel @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ostrict__ordered__ab__semigroup__add_4,axiom,
    strict2144017051up_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__cancel__ab__semigroup__add_5,axiom,
    ordere223160158up_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le_6,axiom,
    ordere236663937imp_le @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ostrict__ordered__comm__monoid__add_7,axiom,
    strict797366125id_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocanonically__ordered__monoid__add,axiom,
    canoni770627133id_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Olinordered__semiring__strict_8,axiom,
    linord20386208strict @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Osemiring__no__zero__divisors_9,axiom,
    semiri1193490041visors @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__ab__semigroup__add_10,axiom,
    ordere779506340up_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oordered__comm__monoid__add_11,axiom,
    ordere216010020id_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocancel__comm__monoid__add_12,axiom,
    cancel1352612707id_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocancel__semigroup__add_13,axiom,
    cancel_semigroup_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Olinordered__semidom_14,axiom,
    linordered_semidom @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oab__semigroup__mult_15,axiom,
    ab_semigroup_mult @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Oab__semigroup__add_16,axiom,
    ab_semigroup_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ocomm__monoid__add_17,axiom,
    comm_monoid_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring__1_18,axiom,
    comm_semiring_1 @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Osemigroup__mult_19,axiom,
    semigroup_mult @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Osemigroup__add_20,axiom,
    semigroup_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring_21,axiom,
    comm_semiring @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Nat_Osemiring__char__0_22,axiom,
    semiring_char_0 @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Omonoid__add_23,axiom,
    monoid_add @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Osemiring__1_24,axiom,
    semiring_1 @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Omult__zero_25,axiom,
    mult_zero @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Rings_Osemiring_26,axiom,
    semiring @ nat @ ( type @ nat ) ).

thf(tcon_Nat_Onat___Groups_Ozero_27,axiom,
    zero @ nat @ ( type @ nat ) ).

%----Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X5: A,Y: A] :
      ( ( if @ A @ $false @ X5 @ Y )
      = Y ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X5: A,Y: A] :
      ( ( if @ A @ $true @ X5 @ Y )
      = X5 ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    ( ( huffma943100115ibling @ a @ ( huffma2094459102Leaves @ a @ ( huffma1759677307erNode @ a @ w @ t_1 @ t_2 ) @ w_a @ a2 @ w_s @ ( huffma943100115ibling @ a @ ( huffma1759677307erNode @ a @ w @ t_1 @ t_2 ) @ b ) ) @ a2 )
    = b ) ).

%------------------------------------------------------------------------------
